<?php
/*--------------------------------------------------------------
   Date.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column;
use Webmozart\Assert\Assert;

class Date implements Column
{
    /**
     * @var string
     */
    private $title;
    
    /**
     * @var string
     */
    private $field;
    
    /**
     * @var string
     */
    private $inputDateFormat;
    
    /**
     * @var string
     */
    private $outputDateFormat;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(string $title, string $field, string $inputDateFormat, string $outputDateFormat)
    {
        Assert::stringNotEmpty($title);
        Assert::stringNotEmpty($field);
        Assert::stringNotEmpty($inputDateFormat);
        Assert::stringNotEmpty($outputDateFormat);
        
        $this->title            = $title;
        $this->field            = $field;
        $this->inputDateFormat  = $inputDateFormat;
        $this->outputDateFormat = $outputDateFormat;
        $this->type             = 'date';
    }
    
    
    /**
     * Create instance.
     */
    public static function create(string $title, string $field, string $inputDateFormat, string $outputDateFormat): self
    {
        return new self($title, $field, $inputDateFormat, $outputDateFormat);
    }
    
    
    /**
     * @inheritDoc
     */
    public function title(): string
    {
        return $this->title;
    }
    
    
    /**
     * @inheritDoc
     */
    public function field(): string
    {
        return $this->field;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
    
    
    /**
     * Return input date format.
     */
    public function inputDateFormat(): string
    {
        return $this->inputDateFormat;
    }
    
    
    /**
     * Return output date format.
     */
    public function outputDateFormat(): string
    {
        return $this->outputDateFormat;
    }
}